<?php
/*
 * Plugin Name: WordPress Product Excel Import & Export for WooCommerce
 * Plugin URI: https://extend-wp.com/product-import-export-for-woocommerce-with-excel/
 * Description: WordPress Plugin to Import/Update/Export Simple products for WooCommerce in Bulk with Excel
 * Version: 4.9
 * Author: extendWP
 * Text Domain: woo-product-excel-importer
 * Domain Path: /languages 
 * Author URI: https://extend-wp.com
 *
 * WC requires at least: 2.2
 * WC tested up to: 7.3
 * 
 * License: GPL2
 * Created On: 10-05-2016
 * Updated On: 24-01-2023
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


$role = get_role( 'administrator' );
$role->add_cap( 'wpeieWoo' );

function woopei_translate() {
			
	load_plugin_textdomain( 'woo-product-excel-importer', false, dirname( plugin_basename(__FILE__) ) . '/languages/' );
			 
}
add_action( 'plugins_loaded', 'woopei_translate' );
		
function woopei_js(){

	//ENQUEUED CSS FILE INSTEAD OF INLINE CSS
	wp_enqueue_style( 'woo-importer_css', plugins_url( "/css/woo-importer.css?v=hg", __FILE__ ) );	
	wp_enqueue_style( 'woo-importer_css');	

	wp_enqueue_script( 'woo-importer-xlsx', plugins_url( "/js/xlsx.js", __FILE__ ), array('jquery') , null, true );	
	wp_enqueue_script( 'woo-importer-xlsx');	
	wp_enqueue_script( 'woo-importer-filesaver', plugins_url( "/js/filesaver.js", __FILE__ ), array('jquery') , null, true );	
	wp_enqueue_script( 'woo-importer-filesaver');	
	
    wp_enqueue_script( 'woopei_js', plugins_url( "/js/woo-importer.js?v=hg", __FILE__ ), array('jquery','jquery-ui-core','jquery-ui-draggable','jquery-ui-droppable') , null, true);	
	wp_enqueue_script( 'woopei_js');
	
    $woopei = array( 
		'RestRoot' => esc_url_raw( rest_url() ),
		'plugin_url' => plugins_url( '', __FILE__ ),
		'siteUrl'	=>	site_url(),
		'nonce' => wp_create_nonce( 'wp_rest' ),
		'ajaxUrl' => admin_url( 'admin-ajax.php' ),	
		'exportfile' => plugins_url( '/js/tableexport.js', __FILE__ )
	);	
    wp_localize_script( 'woopei_js', 'woopei', $woopei );		
	
}
add_action('admin_enqueue_scripts', 'woopei_js');

include( plugin_dir_path(__FILE__) .'/import.php');
include( plugin_dir_path(__FILE__) .'/import_categories.php');
include( plugin_dir_path(__FILE__) .'/export.php');


add_action( 'wp_ajax_woopei_exportProducts', 'woopei_exportProducts' );
add_action( 'wp_ajax_nopriv_woopei_exportProducts',  'woopei_exportProducts' );

//ADD MENU LINK AND PAGE FOR WOO PRODUCT IMPORTER
add_action('admin_menu', 'woopei_menu');


add_action( 'admin_footer', 'woopeiPopup');

function woopei_menu() {
	add_submenu_page( 'edit.php?post_type=product', 'Product Import Export', 'Import from Excel', 'wpeieWoo', 'woo-product-importer', 'woopei_init' );	
	add_submenu_page( 'woocommerce', 'Product Import Export', 'Import from Excel', 'wpeieWoo', 'woo-product-importer', 'woopei_init' );	
	add_menu_page('Woo Product Importer Settings', 'Product Import Export', 'wpeieWoo', 'woo-product-importer', 'woopei_init', 'dashicons-upload','50');
}


//ADD ACTION LINKS
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'add_woopei_links' );

function add_woopei_links ( $links ) {
 $links[] =  "<a href='". admin_url( 'admin.php?page=woo-product-importer' ) . "'>". esc_html__( "Settings","woo-product-excel-importer")."</a>";
 $links[] =  "<a target='_blank' href='https://extend-wp.com/product/wordpress-product-import-export-excel-woocommerce/'>". esc_html__( "Go PRO","woo-product-excel-importer")."</a>";
 $links[] =  "<a href='https://extend-wp.com' target='_blank'>". esc_html__( "More plugins!","woo-product-excel-importer")."</a>";
   return $links;
}


function woopei_header() {
?>
		<img src='<?php echo plugins_url( 'images/woo_product_importer_banner.jpg', __FILE__ ); ?>'style='width:100%;'  />		
		
<?php
}



function woopei_footer() {
?>
	<hr>

	
		<a target='_blank' class='web_logo' href='https://extend-wp.com/'>
			<img  src='<?php echo plugins_url( 'images/extendwp.png', __FILE__ ); ?>' alt='Get more plugins by extendWP' title='Get more plugins by extendWP' />
		</a>	
<?php
}

function woopei_form() { ?>
			<form method="post" id='woo_importer' enctype="multipart/form-data" action= "<?php echo admin_url( 'admin.php?page=woo-product-importer' ); ?>">
				
				<table class="form-table">
					<tr valign="top">
					<th scope="row" style='width:100%;'>
						<div class="uploader" style="background:url(<?php print plugins_url('images/default.png', __FILE__ );?> ) no-repeat center center;
						background-size:cover" >
							<img src="" class='userSelected'/>
							<input type="file"  required name="file" id='woopeiFile'   accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" />
						</div>
					</th>
					<td><?php wp_nonce_field('excel_upload'); ?></td>
					</tr>
				</table>
				
				<?php submit_button('Upload','primary','upload'); ?>

			</form>
			
			<?php  woopei_processData(); ?>	
			
<?php		
}

function woopei_main() { ?>

		
		<div class='left_wrap' >		
			<p><strong><?php esc_html_e("Download the sample excel file, save it and add your products. Upload it using the form below.","woo-product-excel-importer");?> <a href='<?php echo plugins_url( '/sample_excel/import_products.xlsx', __FILE__ ); ?>'><?php esc_html_e("SAMPLE EXCEL FILE","woo-product-excel-importer");?></a></strong></p>			
			<?php		
				woopei_form();
			?>		
		</div>
		
		<div class='right_wrap rightToLeft'>
			<h2  class=' center ' style='background:none;box-shadow:none;color:#000;padding-bottom:2px;font-size:16px !important;line-height:18px;' ><?php esc_html_e( "Need to upload Variable Products, Translations, Images?", "woopei" ); ?></h2>		
			<h2  style='font-size:16px !important;line-height:18px;'  class='premium center '><span class="dashicons dashicons-tag"></span>	<?php esc_html_e( "CHECK PRO VERSION here >>", "woopei" ); ?></h2>
					
			<p class='center'>			

				<iframe width="100%" height="315" src="https://www.youtube.com/embed/zvMBVo6C3eM" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

			</p>
			<p>	
				<?php woopei_Rating(); ?>
			</p>
			<p>	
				<a target='_blank' class='wp_extensions'  style='text-align:center;margin:0 auto' href='https://extend-wp.com'>
					<b>
						<span class="dashicons dashicons-admin-plugins"></span> <?php esc_html_e( "Check More extend-wp Plugins", "woopei" ); ?>
					</b>
				</a>
			</p>
			
		</div>
<?php		
}

//MAIN FORM FOR EXCEL UPLOAD
function woopei_init() {
	?>
	<!-- ADDITION DIV CLASSES AND STYLE MOVED TO CSS FILE-->
	<div class="importer-wrap">

    <?php 
	
	woopei_header();	
			$tabs = array(
				'main' => __("Import/Update Products",'woo-product-excel-importer'),
				'exportProducts' =>  __("Export Products",'woo-product-excel-importer'), 
				'importCategories' =>  __("Import Categories",'woo-product-excel-importer'), 
			);
			
			if(isset($_GET['tab']) && $_GET['tab'] ){
				$current = $_GET['tab'] ;
			}else $current = 'main';
			echo '<h2 class="nav-tab-wrapper" >';
			foreach( $tabs as $tab => $name ){
				$class = ( $tab === $current ) ? ' nav-tab-active' : '';
				echo "<a class='nav-tab$class' href='?page=woo-product-importer&tab=$tab'>$name</a>";
			}
			?>
			<a class='nav-tab premium' href='#'><?php esc_html_e( "Delete Products", 'woo-product-excel-importer' ); ?></a>
			<a class='nav-tab premium' href='#'><?php esc_html_e( "Delete Categories", 'woo-product-excel-importer' ); ?></a>
			<a class='nav-tab instructions' href='<?php echo plugins_url( '/documentation/documentation.docx', __FILE__ ); ?>'><?php _e("Instructions",'woo-product-excel-importer');?></a>			
			<?php 	
			echo '</h2>';?>

	<?php 
		if(isset($_GET['tab']) && $_GET['tab']==='exportProducts' ){
			$export = new WooexportProducts;
			$export->exportProductsDisplay();
		}elseif( isset($_GET['tab']) && $_GET['tab']==='importCategories' ){
			$import_cat = new WooImportCategories;
			$import_cat->importCategoriesDisplay();
		}else woopei_main();
	

	?> 

		<div class='get_ajax' style='width:100%;overflow:hidden;' ></div>
		<?php woopei_footer();	?>
	</div>

	<?php
}

	 function woopeiPopup(){ ?>
		<div id="woopeiPopup">
		  <!-- Modal content -->
		  <div class="modal-content">
			<div class='clearfix'><span class="close">&times;</span></div>
			<div class='clearfix verticalAlign'>
				<div class='columns2'>
					<center>
						<img style='width:90%' src='<?php echo plugins_url( 'images/woo_product_importer_premium.png', __FILE__ ); ?>' style='width:100%' />
					</center>
				</div>
				
				<div class='columns2'>
					<h3><?php esc_html_e( "Go PRO and get more important features!", 'woo-product-excel-importer' ); ?></h3>
					<p>&#10004; <?php esc_html_e( "Import / Update Simple, Variable, Affiliate/External Products with unlimited Attributes + more fields", 'woo-product-excel-importer' ); ?></p>
					<p>&#10004; <?php esc_html_e( "Import / Export", 'woo-product-excel-importer' ); ?> <a target='_blank'  href='https://woocommerce.com/products/woocommerce-subscriptions' ><?php esc_html_e( "Subscription Products", 'woo-product-excel-importer' ); ?></a></p>
					<p>&#10004; <?php esc_html_e( "Import WPML WooCommerce Product Translations with Excel", 'woo-product-excel-importer' ); ?></p>
					<p>&#10004; <?php esc_html_e( "Import / Export ACF custom Product fields and manually defined fields", 'woo-product-excel-importer' ); ?></p>
					<p>&#10004; <?php esc_html_e( "Import / Export YOAST SEO Meta Product fields", 'woo-product-excel-importer' ); ?></p>					
					<p>&#10004; <?php esc_html_e( "Import Product Categories with their Images", 'woo-product-excel-importer' ); ?></p> 
					<p>&#10004; <?php esc_html_e( "Upload and assign Product Image from Url and Product Gallery Images", 'woo-product-excel-importer' ); ?></p>
					<p>&#10004; <?php esc_html_e( "import images & gallery images for custom fields like in ACF PRO", 'woo-product-excel-importer' ); ?></p>
					<p>&#10004; <?php esc_html_e( "Import Custom Taxonomies along with Products", 'woo-product-excel-importer' ); ?></p> 
					<p>&#10004; <?php esc_html_e( "Compatible with", 'woo-product-excel-importer' ); ?> <a target='_blank'  href='https://wordpress.org/plugins/woo-variation-swatches/' ><?php esc_html_e( "Variation Swatches for WooCommerce", 'woo-product-excel-importer' ); ?></a> , <a target='_blank'  href='https://wordpress.org/plugins/woo-variation-gallery/' ><?php esc_html_e( "Delete Categories", 'woo-product-excel-importer' ); ?><?php esc_html_e( "Variation Images Gallery", 'woo-product-excel-importer' ); ?></a> , <a target='_blank'  href='https://yithemes.com/themes/plugins/yith-woocommerce-color-and-label-variations/' ><?php esc_html_e( "YITH WooCommerce Color and Label Variations", 'woo-product-excel-importer' ); ?></a> , <a target='_blank'  href='https://wordpress.org/plugins/perfect-woocommerce-brands/' ><?php esc_html_e( "Perfect Brands for WooCommerce", 'woo-product-excel-importer' ); ?></a></p>
					<p>&#10004; <?php esc_html_e( "Save Fields Mapping Template to save Time", 'woo-product-excel-importer' ); ?></p> 
					<p>&#10004; <?php esc_html_e( "Schedule Product Import / Update with Cron Job from excel URL or Google sheets", 'woo-product-excel-importer' ); ?>.</p>
					<p class='bottomToUp'><center><a target='_blank' class='premium_button' href='https://extend-wp.com/product/wordpress-product-import-export-excel-woocommerce/'><?php esc_html_e( "GET IT HERE", 'woo-product-excel-importer' ); ?></a></center></p>
				</div>
			</div>
		  </div>
		</div>		
		<?php
	}

	function woopei_Rating(){
	?>
		<div class="notice notice-success rating is-dismissible">
			<p>
			<strong><?php esc_html_e( "You like this plugin? ", 'woo-product-excel-importer' ); ?></strong><i class='fa fa-2x fa-smile-o' ></i><br/> <?php esc_html_e( "Then please give us ", 'woo-product-excel-importer' ); ?> 
				<a target='_blank' href='https://wordpress.org/support/plugin/woo-product-excel-importer/reviews/#new-post'>
					<span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span>
				</a>
			</p>
		</div> 	
	<?php	
	}	


	// check more if you like!
	add_action( 'wp_ajax_nopriv_woopei_extensions', 'woopei_extensions' );
	add_action( 'wp_ajax_woopei_extensions', 'woopei_extensions' );
	
	function woopei_extensions(){
		
		if( is_admin() && current_user_can( 'wpeieWoo' ) && isset( $_REQUEST['action'] ) && $_REQUEST['action'] == 'woopei_extensions' ){
			
			$response = wp_remote_get( 'https://extend-wp.com/wp-json/products/v2/product/category/woocommerce' );
			
			if( is_wp_error( $response ) ) {
				return;
			}	
			
			$posts = json_decode( wp_remote_retrieve_body( $response ) );

			if( empty( $posts ) ) {
				return;
			}

			if( !empty( $posts ) ) {
				
				$allowed_html = array(
							'a' => array(
								'style' => array(),
								'href' => array(),
								'title' => array(),
								'class' => array(),
								'id'=>array()                   
							),
							'i' => array('style' => array(),'class' => array(),'id'=>array() ),
							'br' => array('style' => array(),'class' => array(),'id'=>array() ),
							'em' => array('style' => array(),'class' => array(),'id'=>array() ),
							'strong' => array('style' => array(),'class' => array(),'id'=>array() ),
							'h1' => array('style' => array(),'class' => array(),'id'=>array() ),
							'h2' => array('style' => array(),'class' => array(),'id'=>array() ),
							'h3' => array('style' => array(),'class' => array(),'id'=>array() ),
							'h4' => array('style' => array(),'class' => array(),'id'=>array() ),
							'h5' => array('style' => array(),'class' => array(),'id'=>array() ),
							'h6' => array('style' => array(),'class' => array(),'id'=>array() ),
							'img' => array('style' => array(),'class' => array(),'id'=>array() ),
							'p' => array('style' => array(),'class' => array(),'id'=>array() ),
							'ul' => array('style' => array(),'class' => array(),'id'=>array() ),
							'li' => array('style' => array(),'class' => array(),'id'=>array() ),
							'ol' => array('style' => array(),'class' => array(),'id'=>array() ),
							'video' => array('style' => array(),'class' => array(),'id'=>array() ),
							'blockquote' => array('style' => array(),'class' => array(),'id'=>array() ),
							'style' => array(),            
							'img' => array(
								'alt' => array(),
								'src' => array(),
								'title' => array(),
								'style' => array(),
								'class' => array(),
								'id'=>array()
							),
					);				
				
				echo "<div id='woopei_extensions_popup'>";
					echo "<div class='woopei_extensions_content'>";	
						?>
						<span class="woopeiclose">&times;</span>
						<h2><i><?php esc_html_e( 'Extend your WordPress functionality with Extend-WP.com well crafted Premium Plugins!','woo-product-excel-importer' ); ?></i></h2>
						<hr/>
						<?php
						foreach( $posts as $post ) {
							
							echo "<div class='ex_columns'><a target='_blank' href='".esc_url( $post->url )."' /><img src='".esc_url( $post->image )."' /></a>
							<h3><a target='_blank' href='".esc_url( $post->url )."' />". esc_html( $post->title ) . "</a></h3>
							<div>". wp_kses( $post->excerpt, $allowed_html )."</div>
							<a class='button_extensions button-primary' target='_blank' href='".esc_url( $post->url )."' />". esc_html__( 'Get it here', 'woo-product-excel-importer' ) . " <i class='fa fa-angle-double-right'></i></a>
							</div>";
						}
					echo '</div>';
				echo '</div>';	
			}
			wp_die();
		}
	}
	
?>